<?php
// public_html/px/offersadd/zip_gather.php
// Step 1 IVR: ask caller for ZIP, then send it to ringba_px_router.php

header('Content-Type: text/xml; charset=utf-8');

function req_param($key, $default = '')
{
    if (isset($_POST[$key])) return trim((string)$_POST[$key]);
    if (isset($_GET[$key]))  return trim((string)$_GET[$key]);
    return $default;
}

// We’ll pass vertical & subid via the webhook URL in Twilio console
$vertical = req_param('vertical', 'roofing'); // default roofing
$subId    = req_param('subid', 'GG1');

// Build the action URL that Twilio will POST to AFTER Gather
$actionUrl = 'https://cpaapi.store/px/offersadd/ringba_px_router.php'
           . '?vertical=' . urlencode($vertical)
           . '&subid='    . urlencode($subId);

echo '<?xml version="1.0" encoding="UTF-8"?>';
?>
<Response>
    <Gather input="dtmf"
            numDigits="5"
            timeout="8"
            finishOnKey="#"
            action="<?php echo htmlspecialchars($actionUrl, ENT_QUOTES, 'UTF-8'); ?>"
            method="POST">
        <Say>Please enter your five digit zip code, followed by the pound key.</Say>
    </Gather>

    <!-- If no digits are entered, Twilio falls through here -->
    <Say>We did not receive any input. Please call again later.</Say>
    <Hangup/>
</Response>
